<?php
/*--------------------------------------------------------------------
 Reader.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\CombisIdDto;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\WeightDto;
use Gambio\Shop\Properties\SellingUnitWeight\Exceptions\CombisIdDoesNotExistsException;

/**
 * Class Reader
 * @package Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\Readers
 */
class Reader implements ReaderInterface
{
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * Reader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function combinationWeight(CombisIdDto $dto): WeightDto
    {
        $weightResult = $this->connection->createQueryBuilder()
            ->select('combi_weight')
            ->from('products_properties_combis')
            ->where('products_properties_combis_id=' . $dto->combisId())
            ->execute();
        
        if ($weightResult->rowCount() === 0) {
            
            throw new CombisIdDoesNotExistsException($dto->combisId() . ' does not exist');
        }
        
        $weight = (float)$weightResult->fetch(0)['combi_weight'];
        
        return new WeightDto($weight);
    }
}